<?php

date_default_timezone_set('America/Sao_Paulo');

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

$pageMax = 6;
$date = date("Y-m-d");
$voosFiltrados = [];
$totalVoosBrutos = 0;

function processarVoosDaAPI($originId, $date, $pageMax, &$voosFiltrados, &$totalVoosBrutos) {
  for ($page = 1; $page <= $pageMax; $page++) {
    $url = "https://www.bsb.aero/api/v1/Flights?language=br&OriginId={$originId}&TypeId=2&Number=&Date={$date}&PageCurrent={$page}&PageSize=15";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    $resposta = curl_exec($ch);
    $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($status === 200 && $resposta) {
      $voos = json_decode($resposta, true);
      $totalVoosBrutos += count($voos);

      foreach ($voos as $voo) {
        if (!isset($voo['estimatedTime'])) continue;

        $horaVoo = strtotime($voo['estimatedTime']);
        $horaAtual = time();
        $intervalo = ($horaVoo - $horaAtual) / 60; // em minutos
        $statusTexto = strtolower($voo['status']['name'] ?? '');

        // Filtro principal incluindo sempre voos atrasados
        if (($intervalo >= 0 && $intervalo <= 210) || str_contains($statusTexto, 'atrasado')) {
          $voo['origemTipo'] = $originId === 1 ? 'nacional' : 'internacional';
          $voosFiltrados[] = $voo;
        }
      }
    }
  }
}

// Processar voos internacionais (OriginId = 2)
processarVoosDaAPI(2, $date, $pageMax, $voosFiltrados, $totalVoosBrutos);

// Processar voos nacionais (OriginId = 1)
processarVoosDaAPI(1, $date, $pageMax, $voosFiltrados, $totalVoosBrutos);

// Caminho do arquivo final
$arquivoDestino = __DIR__ . '/hora-filtro-3-5.json';
file_put_contents($arquivoDestino, json_encode($voosFiltrados, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));

// Log com hora + dados filtrados
$log = "[" . date("d/m/Y H:i:s") . "] "
     . "Total bruto: {$totalVoosBrutos} | "
     . "Filtrados: " . count($voosFiltrados) . "\n";
file_put_contents(__DIR__ . '/log-filtro.txt', $log, FILE_APPEND);

echo json_encode(["ok" => true, "total" => count($voosFiltrados)]);
